const emailEl = document.getElementById("email");
const next1Btn = document.getElementById("next1");
const error = document.getElementById("error");
const form = document.getElementById("form");

error.style.display = "none";

form.addEventListener("submit", function (e) {
  e.preventDefault();
  let email = emailEl.value;
  if (email === "") {
    emailEl.style.border = "1px solid red";
    error.textContent = "Enter your email";
    error.style.color = "red";
    error.style.fontSize = "0.8rem";
    error.style.display = "block";
  } else if (!email.includes("@")) {
    emailEl.style.border = "1px solid red";
    error.textContent = "Invalid email";
    error.style.fontSize = "0.8rem";
    error.style.color = "red";
    error.style.display = "block";
  } else {
    sessionStorage.setItem("email", `${emailEl.value}`);
    form.submit();
  }
});
